class Screens{
/**
 * @param {Array} screens - An array of HTML ELEMENTS representing screens
 * screens must have data-screen-name attribute and must be arranged in order
 * @param {Object} parent - HTML ELEMENT represent parent container where screens will be appended to
 * 
 */

constructor(screens, parent){
    this.history = []
    this.screens = screens
    this.active = null
    this.parent = parent;
    this.events = {}


    

    //initialize navigation triggers
    let events = this.events;
    screens.forEach(function(screen){
        events[screen.dataset.screenName] = []

    })
// initialize back buttons event delegation
let goBack = this.back.bind(this)
this.parent.addEventListener("click",function(e){
    let back_button = e.target.closest("[data-screen-back]");
    if(back_button) goBack();
})

   this.navigate(0)
}



 hideAll(){
    this.screens.forEach(function(screen){
        screen.classList.add("hide");
    })

}


get activeScreen(){
    let _this = this
    return {
        "index" : _this.screens.indexOf(_this.active),
        "name" : _this.active.dataset.screenName,
    }
}

navigate(screen_name , record = true){
  
    let screen = screen_name;
    if(typeof(screen) == "string"){
    
        screen = this.parent.querySelector(`[data-screen-name='${screen}']`)

    }
    else if(typeof(screen) == "number") screen = this.screens[screen];


    
    this.hideAll()
   
    if(record) this.history.push(this.active)
    this.active = screen
    this.active.classList.remove("hide")
   
    
    let activeScreenName = this.active.dataset.screenName;
    if(this.events[activeScreenName]) {

        for(let trigger of this.events[activeScreenName]){

            trigger(screen);
        }
    }

}
back(){
    let prev_screen = 0;
    if(this.history.length > 1){
        prev_screen = this.history.pop()
        prev_screen = prev_screen ? prev_screen.dataset.screenName : 0;

    }
     

    this.navigate(prev_screen , false)
}

onNavigateTo(screen, func){

    let selected_screen;
    if(typeof(screen) == "string"){
        selected_screen = this.parent.querySelector(`[data-screen-name='${screen}']`)

    }
    else if(typeof(screen) == "number") selected_screen = this.screens[screen];

    let screenName = selected_screen.dataset.screenName;

    this.events[screenName].push(func);


}

reset(){
    this.history = []
    this.active = null
    this.navigate(0)
}

}

